using System;
using System.IO;
using DynaPDF;

namespace table_images
{
   class TableImages
   {
      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		static void Main(string[] args)
		{
		   try
		   {
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            pdf.SetPageCoords(DynaPDF.TPageCoord.pcTopDown);

            CPDFTable tbl = new CPDFTable(pdf, 100, 4, 500.0f, 125.0f);
            tbl.SetBoxProperty(-1, -1, DynaPDF.TTableBoxProperty.tbpBorderWidth, 1.0f, 1.0f, 1.0f, 1.0f);
            tbl.SetBoxProperty(-1, -1, DynaPDF.TTableBoxProperty.tbpCellPadding, 5.0f, 5.0f, 5.0f, 5.0f);
            tbl.SetGridWidth(1.0f, 1.0f);
            tbl.SetFlags(-1, -1, DynaPDF.TTableFlags.tfUseImageCS);

            String[] files = Directory.GetFiles("../../../../test_files/images", "*.jpg");

            int i, n = 0, rowNum = 0;

            rowNum = tbl.AddRow(100.0f);
		      for (i = 0; i < files.Length; i++)
		      {
			      if (n == 4)
			      {
				      rowNum = tbl.AddRow(100.0f);
				      n = 0;
			      }
			      tbl.SetCellImage(rowNum, n++, true, DynaPDF.TCellAlign.coCenter, DynaPDF.TCellAlign.coCenter, 0.0f, 0.0f, files[i], 1);
		      }
		      files = null;

            pdf.Append();

            tbl.DrawTable(50.0f, 50.0f, 742.0f);
            while( tbl.HaveMore())
            {
               pdf.EndPage();
               pdf.Append();
               tbl.DrawTable(50.0f, 50.0f, 742.0f);
            }
            pdf.EndPage();


            // We draw the same table again but this time with the flag tfScaleToRect
            tbl.SetFlags(-1, -1, DynaPDF.TTableFlags.tfScaleToRect | DynaPDF.TTableFlags.tfUseImageCS);
            pdf.Append();

            pdf.SetFont("Arial", DynaPDF.TFStyle.fsRegular, 12.0, true, DynaPDF.TCodepage.cp1252);
            pdf.WriteText(50.0, 50.0, "The same table but the flag tfScaleToRect was set.");

            tbl.DrawTable(50.0f, 65.0f, 742.0f);
            while (tbl.HaveMore())
            {
               pdf.EndPage();
               pdf.Append();
               tbl.DrawTable(50.0f, 50.0f, 742.0f);
            }
            pdf.EndPage();


		      TPDFError err = new TPDFError();
		      n = pdf.GetErrLogMessageCount();
		      for (i = 0; i < pdf.GetErrLogMessageCount(); i++)
		      {
		         pdf.GetErrLogMessage(i, ref err);
		         Console.Write("{0}\n", err.Message);
		      }

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory();
               filePath += "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
   }
}